#!/usr/bin/python3
from heapq import heappush, heappop

n = int(input())

def geohash(x, y):
    k = 2**(n - 1)
    h = 0
    for i in range(2 * n):
        h = h * 2
        if i % 2 == 0:
            if x >= k:
                h += 1
                x -= k
        else:
            if y >= k:
                h += 1
                y -= k
            k //= 2
    return h

def coord(h):
    b = bin(h)[2:]
    while len(b) < 2*n:
        b = '0' + b
    pot = 2**(n - 1)
    x, y = 0, 0
    for i in range(2*n):
        if b[i] == '1':
            if i % 2:
                y += pot
            else:
                x += pot
        if i % 2:
            pot //= 2
    return x, y

a, b = coord(int(input()))
c, d = coord(int(input()))

geo = [[geohash(i, j) for j in range(2**n)] for i in range(2**n)]

g = geo[a][b]
best = [[float('inf') for j in range(2**n)] for i in range(2**n)]
best[a][b] = g
heap = []
heappush(heap, (g, a, b))

while heap:
    val, x, y = heappop(heap)
    if val != best[x][y]:
        continue
    for i in range(4):
        nx = x + [0, 0, -1, 1][i]
        ny = y + [-1, 1, 0, 0][i]
        if nx < 0 or ny < 0 or nx >= 2**n or ny >= 2**n:
            continue
        g = geo[nx][ny]
        if best[x][y] + g < best[nx][ny]:
            best[nx][ny] = best[x][y] + g
            heappush(heap, (best[nx][ny], nx, ny))
print(best[c][d])
